<?php
/*
 * Plugin Name: CSM jz
 * Description: Plugin para gestionar fragmentos de código (CSS, JS, etc.) organizados en lotes con historial y versiones.
 * Version: 2.0
 * Author: Jonathan Alvizures
 * Author URI: https://jeazdesign.com
 * License: GPLv2 or later  
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html  
 * Requires PHP: 7.0
 * Requires at least: 6.3
 * Tested up to: 6.7.1
 * Stable tag: 2.0
 */


if ( ! defined( 'ABSPATH' ) ) exit; // Previene el acceso directo

require_once plugin_dir_path(__FILE__) . 'functions.php';
require_once plugin_dir_path(__FILE__) . 'enqueue-scripts.php';

add_action('admin_enqueue_scripts', 'code_snippet_manager_enqueue_scripts');
function code_snippet_manager_enqueue_scripts($hook) {
    // Solo cargar en el área de administración
    if (is_admin()) {
        // CSS personalizados para el plugin
        wp_enqueue_style('code-snippet-manager-style', plugin_dir_url(__FILE__) . '/assets/css/style.css');
        // JS personalizados para el plugin
        wp_enqueue_script('code-snippet-manager-script', plugin_dir_url(__FILE__) . '/assets/js/script.js', ['jquery'], '1.0', true);
    }

    // Verifica si estamos en una página de edición de post (post.php o post-new.php)
    if (!in_array($hook, ['post-new.php', 'post.php'])) {
        return;
    }

    global $post_type;

    // Asegúrate de que el tipo de post sea 'css_snippet' o 'js_snippet'
    if ($post_type !== 'css_snippet' && $post_type !== 'js_snippet') {
        return;
    }

    // Cargar estilos y scripts específicos para el editor
    wp_enqueue_style('multi-select-tag-style', plugin_dir_url(__FILE__) . '/assets/css/multi-select-tag.css');
    wp_enqueue_script('multi-select-tag-script', plugin_dir_url(__FILE__) . '/assets/js/multi-select-tag.js', ['jquery'], '1.0', true);

    // CodeMirror base
    wp_enqueue_style('codemirror-css', plugins_url('/codemirror/codemirror.min.css', __FILE__));
    wp_enqueue_script('codemirror-js', plugins_url('/codemirror/codemirror.min.js', __FILE__), [], false, true);
    wp_enqueue_script('custom-functions-js', plugins_url('assets/js/functions.js', __FILE__), array('jquery', 'codemirror-js'), null, true);

    // Cargar los modos de CodeMirror
    wp_enqueue_script('codemirror-javascript-js', plugins_url('/codemirror/codemirror_javascript.min.js', __FILE__), [], false, true);
    wp_enqueue_script('codemirror-css-js', plugins_url('/codemirror/codemirror_css.min.js', __FILE__), [], false, true);
    wp_enqueue_script('codemirror-htmlmixed-js', plugins_url('/codemirror/codemirror_htmlmixed.min.js', __FILE__), [], false, true);
    wp_enqueue_script('xml-js', plugins_url('/codemirror/xml.js', __FILE__), [], false, true);
    wp_enqueue_script('htmlembedded-js', plugins_url('/codemirror/htmlembedded.js', __FILE__), [], false, true);


    

    // Obtener el tema seleccionado desde la configuración
    $selected_theme = get_option('code_snippet_manager_theme', 'blackboard'); // Tema por defecto si no se ha seleccionado

    // Cargar únicamente el tema seleccionado de CodeMirror
    wp_enqueue_style($selected_theme . '-css', plugins_url('/codemirror/theme/' . $selected_theme . '.css', __FILE__));
    
    // Pasar el tema seleccionado a JavaScript para usarlo en la inicialización de CodeMirror
    wp_localize_script('code-snippet-manager-script', 'codeSnippetManagerSettings', [
        'theme' => $selected_theme // Pasamos el tema seleccionado
    ]);


    
}



add_action('wp_enqueue_scripts', 'code_snippet_manager_enqueue_code_mirror');
function code_snippet_manager_enqueue_code_mirror() {
    // Solo cargar los scripts si existen elementos con las clases relevantes en la página
    if ( is_page() || is_single() ) {
        // Verificar si el contenido tiene alguna clase 'code-jz_js', 'code-jz_css' o 'code-jz_html'
        if ( has_class_in_content(['code-jz_js', 'code-jz_css', 'code-jz_html'])) {
            wp_enqueue_style('codemirror-css', plugins_url('/codemirror/codemirror.min.css', __FILE__));
            wp_enqueue_script('codemirror-js', plugins_url('/codemirror/codemirror.min.js', __FILE__), [], false, true);
            
            wp_enqueue_script('codemirror-htmlmixed-js', plugins_url('/codemirror/codemirror_htmlmixed.min.js', __FILE__), [], false, true);
            wp_enqueue_script('codemirror-javascript-js', plugins_url('/codemirror/codemirror_javascript.min.js', __FILE__), [], false, true);
            wp_enqueue_script('codemirror-css-js', plugins_url('/codemirror/codemirror_css.min.js', __FILE__), [], false, true);


            wp_enqueue_style('codemirror-front-css', plugins_url('/assets/css/style-front_codemirror.css', __FILE__));

            wp_enqueue_script('xml-js', plugins_url('/codemirror/xml.js', __FILE__), [], false, true);
            wp_enqueue_script('htmlembedded-js', plugins_url('/codemirror/htmlembedded.js', __FILE__), [], false, true);

            

            

            // Asegúrate de incluir tu script personalizado
            wp_enqueue_script('code-snippet-manager-script', plugin_dir_url(__FILE__) . '/assets/js/script_front.js', ['jquery'], '1.0', true);

            // Definir la variable 'codeSnippetManagerSettings' en JavaScript
            wp_localize_script('code-snippet-manager-script', 'codeSnippetManagerSettings', [
                'theme' => 'blackboard', // Aquí puedes personalizar el tema
            ]);


             // Cargar únicamente el tema seleccionado de CodeMirror
            wp_enqueue_style('blackboard-css', plugins_url('/codemirror/theme/blackboard.css', __FILE__));
        }
    }
}

// Función para verificar si el contenido tiene las clases necesarias
// Modificar la detección de clases dentro del contenido, incluso en WPBakery
function has_class_in_content($classes) {
    global $post;
    if (!$post) return false;

    // Aplicar el filtro 'the_content' para procesar los shortcodes de WPBakery
    $content = apply_filters('the_content', $post->post_content);

    // Buscar las clases dentro del contenido ya procesado
    foreach ($classes as $class) {
        if (strpos($content, $class) !== false) {
            return true;
        }
    }
    return false;
}
